package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.network.Handler;
import jamezo97.clonecraft.network.Handler16UpdateGenes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.CCEntityPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;

public class GenePool {
	
	EntityLivingBase entity;
	
	IModifiable mod;
	
	public HashMap<Gene, Integer> geneToLevel = new HashMap<Gene, Integer>();
	
	
	/**
	 * Entity must implement IModifiable
	 * @param entity
	 */
	public GenePool(EntityLivingBase entity){
		this.entity = entity;
		mod = (IModifiable)entity;
	}

	public void writeSpawnData(ByteArrayDataOutput data) {
		data.writeShort(geneToLevel.size());
		for(Iterator<Entry<Gene, Integer>> it = geneToLevel.entrySet().iterator(); it.hasNext();){
			Entry<Gene, Integer> entry = it.next();
			data.writeInt(entry.getKey().getId());
			data.writeInt(entry.getValue());
		}
	}

	public void readSpawnData(ByteArrayDataInput data) {
		int size = data.readShort();
		for(int a = 0; a < size; a++){
			geneToLevel.clear();
			Gene gene = Gene.getGene(data.readInt());
			int stre = data.readInt();
			if(gene != null){
				geneToLevel.put(gene, stre);
			}
		}
	}
	
	boolean genesDirty = false;
	
	public void onUpdate(){
		for(Iterator<Entry<Gene, Integer>> it = geneToLevel.entrySet().iterator(); it.hasNext();){
			Entry<Gene, Integer> entry = it.next();
			Gene gene = entry.getKey();
			int level = entry.getValue();
			if(gene != null){
				gene.updateGene(entity, mod, level);
			}
		}

		if(genesDirty){
			genesDirty = false;
			if(entity instanceof CCEntityPlayerMP){
				CloneCraft.instance.onGenesChanged((CCEntityPlayerMP)entity);
			}
			updateGenesToClient();
		}
	}

	public int getGeneStrength(Gene gene){
		if(hasGene(gene)){
			return geneToLevel.get(gene);
		}
		return -1;
	}

	public void setGene(Gene gene, int level){
		if(!hasGene(gene) || this.getGeneStrength(gene) < level){
			geneToLevel.put(gene, level);
			gene.addGeneEffect(entity, level);
			genesDirty = true;
		}
	}
	
	public boolean removeGene(Gene gene){
		if(geneToLevel.containsKey(gene)){
			geneToLevel.remove(gene);
			genesDirty = true;
			return true;
		}
		return false;
	}
	
	public void updateGenesToClient(){
		Handler handler = new Handler16UpdateGenes(entity, mod);
//		System.out.println("Sent to watching");
		handler.sendToAllWatching(entity);
		if(entity instanceof EntityPlayerMP){
//			System.out.println("Sent to player");
			handler.sendToClient((EntityPlayerMP)entity);
		}
	}
	
	public boolean hasGene(Gene gene){
		return geneToLevel.containsKey(gene);
	}
	
	public NBTTagCompound writeToNBT(NBTTagCompound nbt){
		int[] geneIds = new int[geneToLevel.size()];
		int[] geneLevels = new int[geneToLevel.size()];
		int index = 0;
		for(Iterator<Entry<Gene, Integer>> it = geneToLevel.entrySet().iterator(); it.hasNext();){
			Entry<Gene, Integer> entry = it.next();
			geneIds[index] = entry.getKey().getId();
			geneLevels[index++] = entry.getValue();
		}
		nbt.setIntArray("geneIds", geneIds);
		nbt.setIntArray("geneLevels", geneLevels);
		return nbt;
	}
	
	public NBTTagCompound readFromNBT(NBTTagCompound nbt){
		geneToLevel.clear();
		int[] geneIds = nbt.getIntArray("geneIds");
		int[] geneLevels = nbt.getIntArray("geneLevels");
		if(geneIds != null && geneLevels != null && geneIds.length == geneLevels.length){
			for(int a = 0; a < geneIds.length; a++){
				Gene gene = Gene.getGene(geneIds[a]);
				if(gene != null && geneLevels[a] <= gene.getMaxAmount() && geneLevels[a] >= 0){
					setGene(gene, geneLevels[a]);
				}
			}
		}else{
			Logger.error("Could not read genes. Invalid arrays: " + geneIds + ", " + geneLevels);
		}
		return nbt;
	}
	
	
	public String toString(){
		return geneToLevel.toString();
	}
}
